/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

using Borland.Eco.UmlRt;
using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.WinForm;
using Borland.Eco.Subscription;
using Borland.Eco.Services;
using Borland.Eco.AutoContainers;
using Borland.Eco.Windows.Forms;

namespace Borland.Eco.AutoContainers
{
	///<summary>
	///Class used to keep info about control sizes, margins etc used
	/// when contructing the UI of the DefaultAutoForm.
	///</summary>
	public class LayoutInfo
	{
//		public const int HeightOffset = 4;
//		public const int WidthOffset = 4;
		public const int RightMargin = 4;
		public const int LeftMargin = RightMargin;
		public const int TopMargin = 4;
		public const int BottomMargin = TopMargin;
		public const int VerticalSpace = 4;
		public const int HorizontalSpace = 4;
		public const int Nudge = VerticalSpace / 2;
		public const int PanelNestingSpace = 2 * VerticalSpace;
	}
	/// <summary>
	/// This class makes up the form that is used by the ECO autocontainer mechanisms to display classes.
	/// The various parts (builders) can be reused individually, or this class can be subclassed
	/// and plugged into the autocontainer mechanisms.
	/// </summary>
	public class DefaultAutoForm : System.Windows.Forms.Form, IAutoContainer
	{
#region private helper classes
		private class DeletedSubscriber: SubscriberAdapterBase
		{
			protected override void DoReceive(object sender, EventArgs e, object actualSubscriber)
			{
				DefaultAutoForm form = actualSubscriber as DefaultAutoForm;
				if (form.rh.Element == sender)
					form.Close();
			}
			internal DeletedSubscriber(DefaultAutoForm form): base(form)
			{
			}
		}
#endregion
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.TabControl tabControl;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.TabPage tabProps;
		private System.Windows.Forms.Button btnClose;
		private Borland.Eco.Handles.ReferenceHandle rh;
		private System.Windows.Forms.PictureBox picDragSource;
		private System.Windows.Forms.TabPage tabConstraints;
		private System.Windows.Forms.Label lblBrokenConstraints;
		private const string columnPrefix = "__Column__";
		private DeletedSubscriber deletedSubscriber;
		private TriggerControlsRefresher m_TriggerControlsRefresher; // most hold on to reference to keep subscriber alive
		private bool m_SetupComplete;

#region class properties controlling construction of tabs
		private static bool c_Constraints = true;
		///<summary>
		///If false, Constraints tab are not shown.
		///The actual checking of the class property is in the virtual method <see cref="BuildConstraintsPage"/>.
		///</summary>
		public static bool BuildConstraints { get { return c_Constraints; } set { c_Constraints = value; } }
		private static bool c_MultiLinks = true;
		///<summary>
		///If false, Multilinks tabs are not shown.
		///The actual checking of the class property is in the virtual method <see cref="BuildMultiLinksPages"/>.
		///</summary>
		public static bool BuildMultiLinks { get { return c_MultiLinks; } set { c_MultiLinks = value; } }
		private static bool c_States = true;
		///<summary>
		///If false, States tabs are not shown.
		///The actual checking of the class property is in the virtual method <see cref="BuildStatePage"/>.
		///</summary>
		public static bool BuildStates { get { return c_States; } set { c_States = value; } }
		private static bool c_Methods = true;
		///<summary>
		///If false, Methods tabs are not shown.
		///The actual checking of the class property is in the virtual method <see cref="BuildMethodsPage"/>.
		///</summary>
		public static bool BuildMethods { get { return c_Methods; } set { c_Methods = value; } }
#endregion

#region Plug points to override
		///<summary>
		///Override this method to make adjustments to the constraints page.
		///</summary>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="element"/> is null.</exception>
		protected virtual void BuildConstraintsPage(IElement element, AutoContainerArgs autoContainerArgs)
		{
			if (element == null) throw new ArgumentNullException("element");
			if (BuildConstraints && ConstraintInfoBuilder.HasConstraints(element.UmlType))
			{
				ConstraintInfoBuilder.BuildControls(tabConstraints, rh, element.UmlType, autoContainerArgs);

				Column constraintsBrokenColumn = new Column();
				constraintsBrokenColumn.Expression = "if self.Constraints->Select(c|not c)->Size > 0 then '" + FormsStringRes.sConstraintsBroken + "' else '" + FormsStringRes.sConstraintsOk + "' endif"; // do not localize
				constraintsBrokenColumn.Name = "__Constraints__"; // do not localize
				rh.Columns.Add(constraintsBrokenColumn);
				lblBrokenConstraints.DataBindings.Add(new System.Windows.Forms.Binding("Text", rh, constraintsBrokenColumn.Name)); // do not localize
			}
			else
			{
				tabControl.TabPages.Remove(tabConstraints);
				lblBrokenConstraints.Text = FormsStringRes.sClassHasNoConstraints;
				lblBrokenConstraints.Click -= new System.EventHandler(lblBrokenConstraints_Click);
				lblBrokenConstraints.Cursor = System.Windows.Forms.Cursors.Default;
			}
			lblBrokenConstraints.Visible = BuildConstraints;
		}
		///<summary>
		///Override this method to make adjustments to the "main" page.
		///</summary>
		protected virtual Size BuildMembersPage(IClass umlClass, AutoContainerArgs autoContainerArgs)
		{
			return ControlBuilder.BuildControls(tabProps, rh, umlClass, autoContainerArgs);
		}
		///<summary>
		///Override this method to make adjustments to the multilinks pages.
		///</summary>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="umlClass"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="autoContainerArgs"/> is null.</exception>
		protected virtual void BuildMultiLinksPages(IClass umlClass, AutoContainerArgs autoContainerArgs)
		{
			if (umlClass == null) throw new ArgumentNullException("umlClass");
			if (autoContainerArgs == null) throw new ArgumentNullException("autoContainerArgs");
			if (!BuildMultiLinks) return;
			// get to the ecoclass - where all the goodies are
			IEcoClass ecoClass = umlClass.EcoClass;

			for (int i = 0; i < ecoClass.AllStructuralFeatures.Count; i++)
			{
				IFeature sf = ecoClass.AllStructuralFeatures[i];

				// If member is private and we don't want to show'em, continue
				if (sf.Visibility == VisibilityKind.Private_ &&
					!(autoContainerArgs.MemberVisibility == AutoContainerMemberVisibility.AllMembers))
					continue;
				// If member is protected and we don't want to show'em, continue
				if (sf.Visibility == VisibilityKind.Protected_ &&
				!((autoContainerArgs.MemberVisibility == AutoContainerMemberVisibility.ProtectedOrHigher) ||
				 (autoContainerArgs.MemberVisibility == AutoContainerMemberVisibility.AllMembers)))
					continue;

				if ((sf.FeatureType == FeatureType.AssociationEnd) &&
					(((IAssociationEnd)sf).Multiplicity.Upper > 1)  &&
					(((IAssociationEnd)sf).AssociationEndKind != AssociationEndKind.ToLinkObject))
				{
					// Create a new tab page
					TabPage tabPage = new TabPage();
					tabControl.TabPages.Add(tabPage);
					MultilinkBuilder.BuildControls(tabPage, rh, sf, autoContainerArgs);
				}
			}
		}
		///<summary>
		///Override this method to make adjustments to the state page.
		///</summary>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="umlClass"/> is null.</exception>
		protected virtual TriggerControlsRefresher BuildStatePage(IClass umlClass, AutoContainerArgs autoContainerArgs)
		{
			if (umlClass == null) throw new ArgumentNullException("umlClass");
			if (BuildStates && umlClass.StateMachine != null)
			{
				TabPage tabPage = new TabPage();
				tabControl.TabPages.Add(tabPage);
				tabPage.Text = FormsStringRes.sStateTabCaption;
				return StatePageBuilder.BuildControls(tabPage, EcoSpace, rh);
			}
			else
				return null;
		}
		///<summary>
		///Override this method to make adjustments to the methods page.
		///</summary>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="umlClass"/> is null.</exception>
		protected virtual void BuildMethodsPage(IClass umlClass, AutoContainerArgs autoContainerArgs)
		{
			if (umlClass == null) throw new ArgumentNullException("umlClass");
			if (BuildMethods && umlClass.EcoClass.AllMethods.Count > 0)
			{
				TabPage tabPage = new TabPage();
				tabControl.TabPages.Add(tabPage);
				tabPage.Text = FormsStringRes.sMethodsTabCaption;
				MethodCallBuilder.BuildControls(tabPage, EcoSpace, rh, umlClass, autoContainerArgs);
			}
		}
#endregion

#region IAutoContainer implementation
		///<summary>
		///In order to hook up the form to a type system, the form's referenceHandle must
		///get its EcoSpace property set. This property is a passthrough to the referencehandle's
		///EcoSpace.
		///</summary>
		public EcoSpace EcoSpace
		{
			get { return rh.EcoSpace; } // rh created in constructor, so this should be safe
			set { rh.EcoSpace = value; }
		}
		///<exception cref="ArgumentNullException">Thrown if <paramref name="element"/> is null.</exception>
		///<exception cref="ArgumentNullException">Thrown if <paramref name="autoContainerArgs"/> is null.</exception>
		public void BuildControls(IElement element, AutoContainerArgs autoContainerArgs)
		{
			if (element == null) throw new ArgumentNullException("element"); // Do not localize
			if (autoContainerArgs == null) throw new ArgumentNullException("autoContainerArgs"); // do not localize

			if (element is IObject)
				element = element.CloneValue(true);

			IClass umlClass = element.UmlType as IClass;

			if (umlClass == null)
				// Leave if we're not dealing with a class.
				return;

			// subscribe to the deletion of the object
			if (deletedSubscriber != null)
				deletedSubscriber.Deactivate();
			deletedSubscriber = new DeletedSubscriber(this);
			element.SubscribeToValue(deletedSubscriber);

			rh.StaticValueTypeName = umlClass.Name;

			// Call virtual methods to build the various tabs
			Size size = BuildMembersPage(umlClass, autoContainerArgs);
			BuildConstraintsPage(element, autoContainerArgs);
			BuildMultiLinksPages(umlClass, autoContainerArgs);
			m_TriggerControlsRefresher = BuildStatePage(umlClass, autoContainerArgs);
			BuildMethodsPage(umlClass, autoContainerArgs);

			// Resize form
			if (size.Height > tabProps.Height)
			{
				int newHeight = this.Height + (size.Height - tabProps.Height);
				this.Height = Math.Min(((IConvertible)(Screen.PrimaryScreen.Bounds.Height * 0.75)).ToInt32(null), newHeight);
			}
			MaxLengthSupportFunctions.UpdateMaxLengths(this);
		}
		public void HookUpGUI(EcoSpace ecoSpace, IElement element)
		{
			EcoSpace = ecoSpace;
			rh.SetElement(element);

			if (m_SetupComplete) return;
			m_SetupComplete = true;

			Column c = new Column();
			string selfAsString = columnPrefix + "self"; // do not localize
			c.EventDerivedValue = false;
			c.Expression = "self.asString"; // do not localize
			c.Name = selfAsString;
			rh.Columns.Add(c);

			this.DataBindings.Add(new System.Windows.Forms.Binding("Text", rh, selfAsString)); // do not localize
		}

		///<exception cref="ArgumentNullException">Thrown if <paramref name="autoContainerArgs"/> is null.</exception>
		public void Show(AutoContainerArgs autoContainerArgs)
		{
			if (autoContainerArgs == null)
				throw new ArgumentNullException("autoContainerArgs");
			if (autoContainerArgs.ShowModal)
				this.ShowDialog();
			else
				this.Show();
			this.BringToFront();
		}
#endregion

#region constructor/destructor
		///<summary>
		///Creates a new instance of the class.
		///</summary>
		public DefaultAutoForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			this.rh = new Borland.Eco.Handles.ReferenceHandle();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing && components != null)
				components.Dispose();

			deletedSubscriber.Deactivate();

			base.Dispose(disposing);
		}
#endregion

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DefaultAutoForm));
			this.tabControl = new System.Windows.Forms.TabControl();
			this.tabProps = new System.Windows.Forms.TabPage();
			this.tabConstraints = new System.Windows.Forms.TabPage();
			this.panel1 = new System.Windows.Forms.Panel();
			this.picDragSource = new System.Windows.Forms.PictureBox();
			this.btnClose = new System.Windows.Forms.Button();
			this.lblBrokenConstraints = new System.Windows.Forms.Label();
			this.tabControl.SuspendLayout();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			//
			// tabControl
			//
			this.tabControl.AccessibleDescription = resources.GetString("tabControl.AccessibleDescription");
			this.tabControl.AccessibleName = resources.GetString("tabControl.AccessibleName");
			this.tabControl.Alignment = ((System.Windows.Forms.TabAlignment)(resources.GetObject("tabControl.Alignment")));
			this.tabControl.AllowDrop = true;
			this.tabControl.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabControl.Anchor")));
			this.tabControl.Appearance = ((System.Windows.Forms.TabAppearance)(resources.GetObject("tabControl.Appearance")));
			this.tabControl.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabControl.BackgroundImage")));
			this.tabControl.Controls.Add(this.tabProps);
			this.tabControl.Controls.Add(this.tabConstraints);
			this.tabControl.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabControl.Dock")));
			this.tabControl.Enabled = ((bool)(resources.GetObject("tabControl.Enabled")));
			this.tabControl.Font = ((System.Drawing.Font)(resources.GetObject("tabControl.Font")));
			this.tabControl.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabControl.ImeMode")));
			this.tabControl.ItemSize = ((System.Drawing.Size)(resources.GetObject("tabControl.ItemSize")));
			this.tabControl.Location = ((System.Drawing.Point)(resources.GetObject("tabControl.Location")));
			this.tabControl.Name = "tabControl";
			this.tabControl.Padding = ((System.Drawing.Point)(resources.GetObject("tabControl.Padding")));
			this.tabControl.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabControl.RightToLeft")));
			this.tabControl.SelectedIndex = 0;
			this.tabControl.ShowToolTips = ((bool)(resources.GetObject("tabControl.ShowToolTips")));
			this.tabControl.Size = ((System.Drawing.Size)(resources.GetObject("tabControl.Size")));
			this.tabControl.TabIndex = ((int)(resources.GetObject("tabControl.TabIndex")));
			this.tabControl.Text = resources.GetString("tabControl.Text");
			this.tabControl.Visible = ((bool)(resources.GetObject("tabControl.Visible")));
			this.tabControl.DragOver += new System.Windows.Forms.DragEventHandler(this.tabControl_DragOver);
			//
			// tabProps
			//
			this.tabProps.AccessibleDescription = resources.GetString("tabProps.AccessibleDescription");
			this.tabProps.AccessibleName = resources.GetString("tabProps.AccessibleName");
			this.tabProps.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabProps.Anchor")));
			this.tabProps.AutoScroll = ((bool)(resources.GetObject("tabProps.AutoScroll")));
			this.tabProps.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabProps.AutoScrollMargin")));
			this.tabProps.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabProps.AutoScrollMinSize")));
			this.tabProps.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabProps.BackgroundImage")));
			this.tabProps.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabProps.Dock")));
			this.tabProps.Enabled = ((bool)(resources.GetObject("tabProps.Enabled")));
			this.tabProps.Font = ((System.Drawing.Font)(resources.GetObject("tabProps.Font")));
			this.tabProps.ImageIndex = ((int)(resources.GetObject("tabProps.ImageIndex")));
			this.tabProps.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabProps.ImeMode")));
			this.tabProps.Location = ((System.Drawing.Point)(resources.GetObject("tabProps.Location")));
			this.tabProps.Name = "tabProps";
			this.tabProps.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabProps.RightToLeft")));
			this.tabProps.Size = ((System.Drawing.Size)(resources.GetObject("tabProps.Size")));
			this.tabProps.TabIndex = ((int)(resources.GetObject("tabProps.TabIndex")));
			this.tabProps.Text = resources.GetString("tabProps.Text");
			this.tabProps.ToolTipText = resources.GetString("tabProps.ToolTipText");
			this.tabProps.Visible = ((bool)(resources.GetObject("tabProps.Visible")));
			//
			// tabConstraints
			//
			this.tabConstraints.AccessibleDescription = resources.GetString("tabConstraints.AccessibleDescription");
			this.tabConstraints.AccessibleName = resources.GetString("tabConstraints.AccessibleName");
			this.tabConstraints.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("tabConstraints.Anchor")));
			this.tabConstraints.AutoScroll = ((bool)(resources.GetObject("tabConstraints.AutoScroll")));
			this.tabConstraints.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("tabConstraints.AutoScrollMargin")));
			this.tabConstraints.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("tabConstraints.AutoScrollMinSize")));
			this.tabConstraints.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("tabConstraints.BackgroundImage")));
			this.tabConstraints.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("tabConstraints.Dock")));
			this.tabConstraints.Enabled = ((bool)(resources.GetObject("tabConstraints.Enabled")));
			this.tabConstraints.Font = ((System.Drawing.Font)(resources.GetObject("tabConstraints.Font")));
			this.tabConstraints.ImageIndex = ((int)(resources.GetObject("tabConstraints.ImageIndex")));
			this.tabConstraints.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("tabConstraints.ImeMode")));
			this.tabConstraints.Location = ((System.Drawing.Point)(resources.GetObject("tabConstraints.Location")));
			this.tabConstraints.Name = "tabConstraints";
			this.tabConstraints.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("tabConstraints.RightToLeft")));
			this.tabConstraints.Size = ((System.Drawing.Size)(resources.GetObject("tabConstraints.Size")));
			this.tabConstraints.TabIndex = ((int)(resources.GetObject("tabConstraints.TabIndex")));
			this.tabConstraints.Text = resources.GetString("tabConstraints.Text");
			this.tabConstraints.ToolTipText = resources.GetString("tabConstraints.ToolTipText");
			this.tabConstraints.Visible = ((bool)(resources.GetObject("tabConstraints.Visible")));
			//
			// panel1
			//
			this.panel1.AccessibleDescription = resources.GetString("panel1.AccessibleDescription");
			this.panel1.AccessibleName = resources.GetString("panel1.AccessibleName");
			this.panel1.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("panel1.Anchor")));
			this.panel1.AutoScroll = ((bool)(resources.GetObject("panel1.AutoScroll")));
			this.panel1.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMargin")));
			this.panel1.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("panel1.AutoScrollMinSize")));
			this.panel1.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("panel1.BackgroundImage")));
			this.panel1.Controls.Add(this.picDragSource);
			this.panel1.Controls.Add(this.btnClose);
			this.panel1.Controls.Add(this.lblBrokenConstraints);
			this.panel1.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("panel1.Dock")));
			this.panel1.Enabled = ((bool)(resources.GetObject("panel1.Enabled")));
			this.panel1.Font = ((System.Drawing.Font)(resources.GetObject("panel1.Font")));
			this.panel1.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("panel1.ImeMode")));
			this.panel1.Location = ((System.Drawing.Point)(resources.GetObject("panel1.Location")));
			this.panel1.Name = "panel1";
			this.panel1.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("panel1.RightToLeft")));
			this.panel1.Size = ((System.Drawing.Size)(resources.GetObject("panel1.Size")));
			this.panel1.TabIndex = ((int)(resources.GetObject("panel1.TabIndex")));
			this.panel1.Text = resources.GetString("panel1.Text");
			this.panel1.Visible = ((bool)(resources.GetObject("panel1.Visible")));
			//
			// picDragSource
			//
			this.picDragSource.AccessibleDescription = resources.GetString("picDragSource.AccessibleDescription");
			this.picDragSource.AccessibleName = resources.GetString("picDragSource.AccessibleName");
			this.picDragSource.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("picDragSource.Anchor")));
			this.picDragSource.BackColor = System.Drawing.SystemColors.Control;
			this.picDragSource.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("picDragSource.BackgroundImage")));
			this.picDragSource.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.picDragSource.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("picDragSource.Dock")));
			this.picDragSource.Enabled = ((bool)(resources.GetObject("picDragSource.Enabled")));
			this.picDragSource.Font = ((System.Drawing.Font)(resources.GetObject("picDragSource.Font")));
			this.picDragSource.Image = ((System.Drawing.Image)(resources.GetObject("picDragSource.Image")));
			this.picDragSource.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("picDragSource.ImeMode")));
			this.picDragSource.Location = ((System.Drawing.Point)(resources.GetObject("picDragSource.Location")));
			this.picDragSource.Name = "picDragSource";
			this.picDragSource.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("picDragSource.RightToLeft")));
			this.picDragSource.Size = ((System.Drawing.Size)(resources.GetObject("picDragSource.Size")));
			this.picDragSource.SizeMode = ((System.Windows.Forms.PictureBoxSizeMode)(resources.GetObject("picDragSource.SizeMode")));
			this.picDragSource.TabIndex = ((int)(resources.GetObject("picDragSource.TabIndex")));
			this.picDragSource.TabStop = false;
			this.picDragSource.Text = resources.GetString("picDragSource.Text");
			this.picDragSource.Visible = ((bool)(resources.GetObject("picDragSource.Visible")));
			this.picDragSource.MouseUp += new System.Windows.Forms.MouseEventHandler(this.picDragSource_MouseUp);
			this.picDragSource.MouseMove += new System.Windows.Forms.MouseEventHandler(this.picDragSource_MouseMove);
			this.picDragSource.MouseDown += new System.Windows.Forms.MouseEventHandler(this.picDragSource_MouseDown);
			//
			// btnClose
			//
			this.btnClose.AccessibleDescription = resources.GetString("btnClose.AccessibleDescription");
			this.btnClose.AccessibleName = resources.GetString("btnClose.AccessibleName");
			this.btnClose.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnClose.Anchor")));
			this.btnClose.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnClose.BackgroundImage")));
			this.btnClose.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnClose.Dock")));
			this.btnClose.Enabled = ((bool)(resources.GetObject("btnClose.Enabled")));
			this.btnClose.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnClose.FlatStyle")));
			this.btnClose.Font = ((System.Drawing.Font)(resources.GetObject("btnClose.Font")));
			this.btnClose.Image = ((System.Drawing.Image)(resources.GetObject("btnClose.Image")));
			this.btnClose.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnClose.ImageAlign")));
			this.btnClose.ImageIndex = ((int)(resources.GetObject("btnClose.ImageIndex")));
			this.btnClose.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnClose.ImeMode")));
			this.btnClose.Location = ((System.Drawing.Point)(resources.GetObject("btnClose.Location")));
			this.btnClose.Name = "btnClose";
			this.btnClose.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnClose.RightToLeft")));
			this.btnClose.Size = ((System.Drawing.Size)(resources.GetObject("btnClose.Size")));
			this.btnClose.TabIndex = ((int)(resources.GetObject("btnClose.TabIndex")));
			this.btnClose.Text = resources.GetString("btnClose.Text");
			this.btnClose.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnClose.TextAlign")));
			this.btnClose.Visible = ((bool)(resources.GetObject("btnClose.Visible")));
			this.btnClose.Click += new System.EventHandler(this.btnClose_Click);
			//
			// lblBrokenConstraints
			//
			this.lblBrokenConstraints.AccessibleDescription = resources.GetString("lblBrokenConstraints.AccessibleDescription");
			this.lblBrokenConstraints.AccessibleName = resources.GetString("lblBrokenConstraints.AccessibleName");
			this.lblBrokenConstraints.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("lblBrokenConstraints.Anchor")));
			this.lblBrokenConstraints.AutoSize = ((bool)(resources.GetObject("lblBrokenConstraints.AutoSize")));
			this.lblBrokenConstraints.Cursor = System.Windows.Forms.Cursors.Hand;
			this.lblBrokenConstraints.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("lblBrokenConstraints.Dock")));
			this.lblBrokenConstraints.Enabled = ((bool)(resources.GetObject("lblBrokenConstraints.Enabled")));
			this.lblBrokenConstraints.Font = ((System.Drawing.Font)(resources.GetObject("lblBrokenConstraints.Font")));
			this.lblBrokenConstraints.Image = ((System.Drawing.Image)(resources.GetObject("lblBrokenConstraints.Image")));
			this.lblBrokenConstraints.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblBrokenConstraints.ImageAlign")));
			this.lblBrokenConstraints.ImageIndex = ((int)(resources.GetObject("lblBrokenConstraints.ImageIndex")));
			this.lblBrokenConstraints.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("lblBrokenConstraints.ImeMode")));
			this.lblBrokenConstraints.Location = ((System.Drawing.Point)(resources.GetObject("lblBrokenConstraints.Location")));
			this.lblBrokenConstraints.Name = "lblBrokenConstraints";
			this.lblBrokenConstraints.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("lblBrokenConstraints.RightToLeft")));
			this.lblBrokenConstraints.Size = ((System.Drawing.Size)(resources.GetObject("lblBrokenConstraints.Size")));
			this.lblBrokenConstraints.TabIndex = ((int)(resources.GetObject("lblBrokenConstraints.TabIndex")));
			this.lblBrokenConstraints.Text = resources.GetString("lblBrokenConstraints.Text");
			this.lblBrokenConstraints.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("lblBrokenConstraints.TextAlign")));
			this.lblBrokenConstraints.Visible = ((bool)(resources.GetObject("lblBrokenConstraints.Visible")));
			this.lblBrokenConstraints.Click += new System.EventHandler(this.lblBrokenConstraints_Click);
			//
			// DefaultAutoForm
			//
			this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
			this.AccessibleName = resources.GetString("$this.AccessibleName");
			this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
			this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
			this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
			this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
			this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
			this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.tabControl);
			this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
			this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
			this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
			this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
			this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
			this.Name = "DefaultAutoForm";
			this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
			this.ShowInTaskbar = false;
			this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
			this.Text = resources.GetString("$this.Text");
			this.tabControl.ResumeLayout(false);
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

#region Dragsource
		private bool dragInitiated;
		private Rectangle startDragArea;
		private int dragZoneSize = 5;

		private void picDragSource_MouseDown(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			// Only do left-click drags
			if (e.Button != MouseButtons.Left) return;

			dragInitiated = true;
			startDragArea = new Rectangle(e.X - dragZoneSize, e.Y - dragZoneSize, dragZoneSize * 2, dragZoneSize * 2);
		}

		private void picDragSource_MouseUp(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			dragInitiated = false;
		}

		private void picDragSource_MouseMove(object sender, System.Windows.Forms.MouseEventArgs e)
		{
			if (dragInitiated && !startDragArea.Contains(e.X, e.Y))
			{
				dragInitiated = false;
				IObject draggedObject = rh.Element as IObject;
				if (draggedObject != null)
				{
					((Control)sender).DoDragDrop(new DraggedElement(draggedObject), DragDropEffects.Link);
				}
			}
		}
#endregion

#region Events
		private void lblBrokenConstraints_Click(object sender, System.EventArgs e)
		{
			tabControl.SelectedIndex = tabConstraints.TabIndex;
		}
		private void btnClose_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
#endregion

		private void tabControl_DragOver(object sender, System.Windows.Forms.DragEventArgs e)
		{
			Point p = tabControl.PointToClient(new Point(e.X, e.Y));
			for (int i = 0; i < tabControl.TabPages.Count; i++)
				if (tabControl.GetTabRect(i).Contains(p))
				{
					tabControl.SelectedIndex = i;
					return;
				}
		}
	}
}
